---------------------------------------------------------


---------------------------------------------------------
function eventOnAutoBattleEnd(win_side, win_num)
	log("auto_battle", "++WINNER: ", win_side, win_num,"++")

	if ( (Sectors[CONTESTED_SECTOR].owner ~= win_side) and (win_side ~= nil) ) then
		sendMessage(win_side.."_takes_"..CONTESTED_SECTOR, NEW_ENTRY)
		--
		if((owner == CURRENT_ALLY) and (CURRENT_ALLY==CORP)) then
			if (FIRST_SECTOR_LOST == false) then
				FIRST_SECTOR_LOST = true
				
				sendMail("janus_02", nil, nil, false)
				--Emails["janus_02"].send(false)
				addEntry("j_02", false)
			end
		end
		--
		applyResults(CONTESTED_SECTOR, win_side, win_num)
	elseif ( Sectors[CONTESTED_SECTOR].owner == win_side ) then
		if ((win_side == ARMY) or (win_side == CORP)) then
			sound2D("ui/misc/army_win")
		elseif ((win_side == MARAUDERS) or (win_side == PIRATS)) then
			sound2D("ui/misc/marauders_win_2")
		elseif (win_side == BUTSI) then
			sound2D("ui/misc/butsi_win_3")
		end
		sendMessage(win_side.."_saves_"..CONTESTED_SECTOR, NEW_ENTRY)
	end

	CONTESTED_SECTOR = ""
end
--
function eventOnAutoBattaleUpdate(sector, attacker, defender, a_num, d_num, fast)
	log("auto_battle", "==TICK=========================================")
		
	local res = autoResolveTick(sector, attacker, defender, a_num)
	
	if ( (a_num ~= 0) and (d_num ~= 0) and (fast ~= true) ) then
		if (math.random() < 0.10) then
			if ((res == ARMY) or (res == CORP)) then
				sound2D("ui/misc/army_attacks")
			elseif (res == BUTSI) then
				sound2D("ui/misc/butsi_attack")
			elseif ((res == MARAUDERS) or (res == PIRATS)) then
				sound2D("ui/misc/marauders_attack")
			end
		end
	end
	
	return res
end
--
function autoResolveTick(sector, o, d, o_num)
	local militia_info = getMilitiaInfo(sector)
	local base_chance = 0.4 * CDMOD   --                   
	local d_slots = militia_info.slots
	local o_power = UnitsPower[o].attack
	local d_power = 0
	local d_power_sum = 0
	local chance = 0
	local d_num = militia_info.num
	
	local calc_power = function(index, value)
		d_power_sum = d_power_sum + militia_info[value].power
	end
	
	table.foreach(d_slots, calc_power)
			
	if (d_num == 0) then
		log("auto_battle", "AutoResolve:  !!")
		return d
	elseif (o_num == 0) then
		log("auto_battle", "AutoResolve:  !!")
		return o
	end

	if (d_power_sum == 0) then
		log("auto_battle", "AutoResolve:   !!")
		return d
	elseif (o_power == 0) then
		log("auto_battle", "AutoResolve:   ")
		return o
	end

	d_power = d_power_sum / d_num

	chance = base_chance * (o_power/d_power) * (o_num/d_num) * ((100 - Sectors[sector].defense) / 100)		-- 0.25 * (10/5 * 6/3) = 1
	
	if (chance > 0.95) then
		chance = 0.95
	end
	
	local rnd = math.random()
	
	if (chance > rnd) then
		local slot_to_reduce = d_slots[1]
		--log("!slot_to_reduce", "init",sector, slot_to_reduce)

		local select_slot = function(index, value)
			if ((militia_info[slot_to_reduce].num == 0) or
				((militia_info[value].power < militia_info[slot_to_reduce].power) and (militia_info[value].num > 0))) then
				--log("!slot_to_reduce", "clk", value)
				slot_to_reduce = value
			end
		end

		table.foreach(d_slots, select_slot)
		
		local remain = militia_info[slot_to_reduce].num - 1
		--log("!slot_to_reduce", "now", slot_to_reduce, militia_info[slot_to_reduce].num, remain)
		if (remain >= 0) then
			militia_info[slot_to_reduce].num = remain
			setMilitia2(sector, slot_to_reduce, militia_info[slot_to_reduce].mtype, remain)
		end

		return d			--   ->   
	else
		return o			--   ->   
	end

end
---------------------------------------------------------
function applyResults(sector, win_side, win_num)
--	local rnd = math.random(6)
--			
--	if ((math.random() > 0.5) and (rnd < 4)) then
--		sound2D("Enemy/Female/0"..rnd.."/laugh_01")
--	else
--		sound2D("Enemy/Male/0"..rnd.."/laugh_01")
--	end
	
	if (sector == "mines") then
		if (_Forces[win_side] ~= nil) then
			setGVAR("MI_OWNER", _Forces[win_side])
		end
	end
	
	if (Sectors[sector].owner == CURRENT_ALLY) then
		changeBadReputation(2)
		sound2D("ui/misc/sector_lost_2")
	end
	
	if ((win_side == MARAUDERS) or (win_side == PIRATS)) then
		--marauders and their brothers in arms do not conquer sectors, they raid them for valuables
		raidSector(win_side, sector)
		sound2D("ui/misc/marauders_win_2")
	else
		
		if ((win_side == ARMY) or (win_side == CORP)) then
			sound2D("ui/misc/army_win")
		elseif (win_side == BUTSI) then
			sound2D("ui/misc/butsi_win_3")
		end
		
		destroyUpgrades(sector)
		--
		Sectors[sector].owner = win_side

		log("auto_battle", "New owner", win_side)

		local squads = math.ceil(win_num/5)

		log("auto_battle", "squads to fill", squads)

		if (squads == 1) then
			setMilitia2(sector, 1, win_side, win_num)
		else
			local num_left = win_num

			for count = 1, squads, 1 do
				local num = 5

				if (num_left < 5) then
					num = num_left
				end

				log("auto_battle", "Filling squad", count, "Num", num)					

				setMilitia2(sector, count, win_side, num)

				num_left = num_left - num

				log("auto_battle", "Squads left", squads - count, "Num left", num_left)

				if (num_left <= 0) then
					log("auto_battle", "All squads filled")
					break
				end
			end
		end
	end
end
--